  org 100h  ; assume ax=bx=0 si=100h sp=-2

  mov fs,ax   ; fs=0

  mov al,[fs:0x46c]
  mov [LASTTICK],al

  jmp S
CZ dw -512*24
CZSM dw 16
T dw 0
TDIV dw 16
NOTES dw 7
SONGPOS dw 100h
LASTTICK db 0
SONG:
  db 0x3F            ; aas
  db 0xC1,122,90h,42 ; sar word[bp+si-0x70],42
  db 91h             ; xchg ax,cx


S:mov al,13h
  int 10h
  mov dx,3c8h
  salc
  out dx,al
  inc dx

P:push ax
  mul al   ; x*x (12)
  imul bx,ax,10
  shr ax,5 ; 7
  mul al   ; x*x*x*x (14)
  sub bx,ax
  mov al,bh
  out dx,al
  out dx,al
  pop ax
  out dx,al
  add ah,2Eh
  adc al,ch
  loop P

  push 0a000h
  pop es

  fninit

M:xor di,di  ; loop
  mov cl,200
Y:mov bx,320

  mov ax,cx ; y
  sub ax,100
  push ax
  fild word[CZ]
  fidiv word[-4] ; y-100
  fiadd word[T]
  fidiv word[TDIV]
  fsin
  fimul word[CZSM]
  fistp word[-4]
  pop dx
X:
  call I

  inc di

  imul bp,5
  inc bp

  dec bx
  jnz X
  loop Y
  inc bp
  inc word[T]

; Play notes for the current tick?

  mov al,[fs:0x46c]
  push ax
  sub al,4
  sub al,[LASTTICK]
  pop ax
  js SKIP_MUSIC
  mov [LASTTICK],al
  
  pusha

  mov si,SONG
  mov dx,331h
  outsb       ; 0x3F: UART simple mode
  dec dx
  outsb       ; 0xC1: Program change, channel 2
  outsb       ; 122: Seashore

  mov cl,31   ; max polyphony = 31 + seashore
  xor ebp,ebp ; the cycle has 32 ticks: which ticks have played a note?
  xor bx,bx   ; note time
  mov ax,18   ; number of ticks between notes = 18

N:pusha

  mov di,[SONGPOS]
  lea ax,[bx+di] ; song time minus note time
  and ax,801Fh   ; should it play yet? and on this tick?
  jnz O

  imul ax,cx,-12 ; 12 notes in octave
  add ax,34*7+12*31+5 ; first note is D
  div byte[NOTES]  ; 7 notes in scale

  outsb       ; 0x90: Note On, channel 1
  out dx,al   ; note
  outsb       ; velocity 42
  cmp al,38   ; new seashore sound on lowest two notes
  ja O
  outsb       ; Note On, channel 2
  out dx,al   ; note 37 or 38
  out dx,al   ; velocity 37 or 38

O:popa
  bts ebp,ebx
  jnc B
  xor al,29^18; if there's a note on this tick, switch 18<->29
B:sub bx,ax   ; note time += 18 or 29

  loop N

  inc word[SONGPOS]
  
  popa
  
SKIP_MUSIC:

  in al,60h
  cmp al,1
  jnz M

I:
  pusha
  xchg ax,bx
  sub al,160
  imul al

  xchg ax,cx

  cmp al,100
  ja R
  neg al
  add al,200
  add al,dl
R:
  mov bl,-200
  add bl,al
  sar bl,1

  sub al,150
  imul al

  add cx,ax
  mov dx,100h
  add ch,2
  div cx

  shr bp,6
  add ax,bp
  shr ax,7

  cmp ax,185
  jb Z
  sub ax,80
  add ax,ax
  or ah,ah
  jz Q
  mov al,254
  jmp Q
Z:
  cmp di,32000
  jae K
  xor cx,di
  ror cx,cl
  imul cx,5+96
  test ch,ch
  jnz K
  shr ax,1
  add al,96
K:

  sub ax,bx
Q:stosb
  popa

  ret
